/////////////////////////////////////////////////////////////
// CINEMA SDK : SCENEHOOK																	 //
/////////////////////////////////////////////////////////////
// VERSION    : CINEMA 4D																	 //
/////////////////////////////////////////////////////////////
// (c) 1989-2002 MAXON Computer GmbH, all rights reserved	 //
/////////////////////////////////////////////////////////////

#ifndef __C4D_SCENEHOOKDATA_H
#define __C4D_SCENEHOOKDATA_H

#include "c4d_nodedata.h"

class String;
class BaseContainer;
class BaseBitmap;
class BaseDocument;
class BaseObject;
class BaseDraw;
class BaseDrawHelp;
class BaseThread;
class CDialog;
class PriorityList;
class EditorWindow;
class PluginSceneHook;

#define PLUGINFLAG_SCENEHOOK_NOTDRAGGABLE	(1<<0)

#define SCENEHOOKDRAW_ACTIVE_PASS		(1<<0)
#define SCENEHOOKDRAW_INACTIVE_PASS	(1<<1)

class SceneHookData : public NodeData
{
	public:
		////inherited from NodeData////
		//virtual Bool Init(GeListNode *node);
		//virtual void Free(GeListNode *node);
		//virtual Bool Read(GeListNode *node, HyperFile *hf, LONG level);
		//virtual Bool Write(GeListNode *node, HyperFile *hf);
		//virtual Bool Message(GeListNode *node, LONG type, void *data);
		//virtual Bool CopyTo(NodeData *dest, GeListNode *snode, GeListNode *dnode, LONG flags, AliasTrans *trn);
		//virtual void GetBubbleHelp(GeListNode *node, String &str);
		//virtual BaseDocument* GetDocument(GeListNode *node);
		//virtual LONG GetBranchInfo(GeListNode *node, BranchInfo *info, LONG max);
		//virtual Bool GetDDescription(GeListNode *node, Description *description,LONG &flags);
		//virtual Bool GetDParameter(GeListNode *node, const DescID &id,GeData &t_data,LONG &flags);
		//virtual Bool GetDEnabling(GeListNode *node, const DescID &id,GeData &t_data,LONG flags,const BaseContainer *itemdesc);
		//virtual Bool SetDParameter(GeListNode *node, const DescID &id,const GeData &t_data,LONG &flags);
		//static NodeData *Alloc(void) { return gNew MyNodeData; }
		////inherited from NodeData////

		virtual Bool MouseInput			(PluginSceneHook *node, BaseDocument *doc, BaseDraw *bd, EditorWindow *win, const BaseContainer &msg);
		virtual Bool GetCursorInfo	(PluginSceneHook *node, BaseDocument *doc, BaseDraw *bd, Real x, Real y, BaseContainer &bc);
		virtual Bool Draw						(PluginSceneHook *node, BaseDocument *doc, BaseDraw *bd, BaseDrawHelp *bh, BaseThread *bt,LONG flags);

		virtual Bool AddToExecution (PluginSceneHook *node, PriorityList *list);
		virtual LONG InitSceneHook	(PluginSceneHook *node, BaseDocument *doc, BaseThread *bt);
		virtual void FreeSceneHook	(PluginSceneHook *node, BaseDocument *doc);
		virtual LONG Execute				(PluginSceneHook *node, BaseDocument *doc, BaseThread *bt, LONG priority, LONG flags);
};

Bool RegisterSceneHookPlugin(LONG id, const String &str, LONG info, DataAllocator *g, LONG priority, LONG disklevel, void *emulation=NULL);

#endif
